# Habit Tracker with Data Visualization
## 🗒️ Description
The Habit Tracker with Data Visualization project allows users to add, update, delete, and mark habits as completed. Users can also visualize their habit completion data using simple graphs.

## Features:
1. Add, update, and delete habits.
2. Mark habits as completed for each day.
3. View a calendar of completed habits.
4. Generate visual reports of habit completion.

## Required Modules:
- `json`
- `datetime`
- `matplotlib`

## How to Install Required Modules:
To install the required modules, use the following steps:

1. Open Command Prompt (Windows) or Terminal (macOS/Linux).
2. Install matplotlib module by running:
```sh
pip install matplotlib
```
## ▶️ How to Run the Script
1. Clone the Repository:
   ```
   git clone https://github.com/ShravanDalavi/Simple-Python-Mini-Projects.git
   ```
2. Navigate to Directory:
   ```bash 
          cd Simple-Python-Mini-Projects/Habit\ Tracker\ with\ Data\ Visualization
   ```
2. Run the Script:
   ```bash 
        python habit_tracker.py
   ```
- Visualize your habits with charts and graphs.

## Example Usage:
```markdown
Habit Tracker
1. Add Habit
2. Delete Habit
3. Mark Habit as Completed
4. View All Habits
5. Save Habits to File
6. Load Habits from File
7. Visualize Habit
8. Exit
Choose an option: 1
Enter habit name: Exercise

Habit Tracker
1. Add Habit
2. Delete Habit
3. Mark Habit as Completed
4. View All Habits
5. Save Habits to File
6. Load Habits from File
7. Visualize Habit
8. Exit
Choose an option: 3
Enter habit name: Exercise
Enter date (YYYY-MM-DD) or press Enter for today: 2024-08-07
```
## Acknowledgments:
- This project uses [matplotlib](https://matplotlib.org/) for data visualization.
